/* $Id: list.c,v 1.6 89/05/06 17:13:31 lee Exp $
 * GLIB - a Generic LIBrarian and editor for synths
 * Tim Thompson
 * modified by everyone
 *
 * The E array is the list of synths that can be handled.
 * GLIB is completely driven from the stuff in the editinfo structure.
 * To add/delete a synth, just add/delete an entry to the E array,
 * and provide the functions.  The #defines at the top provide a
 * convenient way of including/excluding synths that are already
 * supported.
 * $Log:	list.c,v $
 * Revision 1.6  89/05/06  17:13:31  lee
 * rel. to comp.sources.misc
 * 
 */

#ifdef KAWAIK1
#define K1multi
#define K1single
#define PATDATAID 0xf1
#define TONDATAID 0xf3
#endif

#ifdef ROLANDD10
#define D10pat
#define D10tim
#define D10wfg
#define D10tvf
#define D10tva
#define D10rsu
#define D10urp
#define D10tra
#define PATDATAID 0xf1
#define TIMDATAID 0xf2
#define TONDATAID 0xf3
#define RSUDATAID 0xf4
#define URPDATAID 0xf5
#define TRADATAID 0xf6
#endif

#include "glib.h"

#ifdef DX100
extern dxtxdin(), dxtxdout(), dx1snof(), dx1sbulk(), dx1gbulk(), dx1sedit();
extern char *dx1nof();
extern struct paraminfo Pdx100[];
extern struct labelinfo Ldx100[];
#endif

#ifdef TX81Z
extern dxtxdin(), dxtxdout(), dx1snof(), dx1sbulk(), dx1gbulk(), dx1sedit();
extern char *dx1nof();
extern struct paraminfo Ptx81z[];
extern struct labelinfo Ltx81z[];
#endif

#ifdef TX81ZPERF
extern tx8pdin(), tx8pdout(), tx8psedit(), tx8psbulk(), tx8pgbulk(), tx8psnof();
extern char *tx8pnof();
extern struct paraminfo Ptx81p[];
extern struct labelinfo Ltx81p[];
#endif

#ifdef MWAVE
extern muwdin(), muwdout();
extern mwtdin(), mwtdout();
extern mspfilein(), mspfileout(), mmpfilein(), mmpfileout();
extern mwtfilein(), mwtfileout(), muwfilein(), muwfileout();
extern mspsedit(), mspsbulk(), mspgbulk(), mspsnof();
extern mmpsedit(), mmpsbulk(), mmpgbulk(), mmpsnof();
extern mwtsedit(), mwtsbulk(), mwtsone(), mwtgbulk(), mwtsnof();
extern muwsedit(), muwsbulk(), muwsone(), muwgbulk(), muwsnof();
extern mwtcvtnum(), muwcvtnum();
extern char *mspnof(), *mmpnof(), *mwtnof(), *mwvnum();
extern char *mwtvnum(), *muwnof(), *muwvnum();
extern struct paraminfo Pmuw[];
extern struct labelinfo Lmuw[];
extern struct paraminfo Pmwt[];
extern struct labelinfo Lmwt[];
#endif

#ifdef DEP5
extern struct paraminfo Pdep5[];
extern struct labelinfo Ldep5[];
extern dep5din(), dep5dout(), dep5snof(), dep5sone(), dep5sedit();
extern char *dep5nof();
#endif

#ifdef DW8000
extern struct paraminfo Pdw800[];
extern struct labelinfo Ldw800[];
extern dw8din(), dw8dout(), dw8snof(), dw8sone(), dw8gbulk();
extern dw8numv(), dw8sedit();
extern char *dw8nof(), *dw8vnum();
#endif

#ifdef KAWAIK5
extern struct paraminfo Pk5s[], Pk5m[];
extern struct labelinfo Lk5s[], Lk5m[];
extern k5sdin(), k5sdout(), k5ssnof(), k5ssone();
extern k5mdin(), k5mdout(), k5msnof(), k5msone();
extern k5ssbulk(), k5msbulk();
extern k5numv(), k5ssedit(), k5msedit(), k5sgbulk(), k5mgbulk();
extern char *k5snof(), *k5mnof(), *k5vnum();
#endif

#ifdef D10pat
extern struct paraminfo Pdpat[];
extern struct labelinfo Ldpat[];
extern dpatdin(), dpatdout(), dpatsnof(), dpatsone(), dpatgbulk();
extern dnumpat(), dpatsedit(), dpatsbulk();
extern char *dpatnof(), *dpatnum();
#endif

#ifdef D10tim
extern struct paraminfo Pdtim[];
extern struct labelinfo Ldtim[];
extern dtimdin(), dtimdout(), dtimsnof(), dtimsone(), dtimgbulk();
extern dnumtim(), dtimsedit(), dtimsbulk();
extern char *dtimnof(), *dtimnum();
#endif

#ifdef D10wfg
extern struct paraminfo Pdwfg[];
extern struct labelinfo Ldwfg[];
extern dwfgdin(), dwfgdout(), dtonsnof(), dtonsone(), dtongbulk();
extern dnumton(), dtonsedit(), dtonsbulk();
extern char *dtonnof(), *dtonnum();
#endif

#ifdef D10tvf
extern struct paraminfo Pdtvf[];
extern struct labelinfo Ldtvf[];
extern dtvfdin(), dtvfdout(), dtonsnof(), dtonsone(), dtongbulk();
extern dnumton(), dtonsedit(), dtonsbulk();
extern char *dtonnof(), *dtonnum();
#endif

#ifdef D10tva
extern struct paraminfo Pdtva[];
extern struct labelinfo Ldtva[];
extern dtvadin(), dtvadout(), dtonsnof(), dtonsone(), dtongbulk();
extern dnumton(), dtonsedit(), dtonsbulk();
extern char *dtonnof(), *dtonnum();
#endif

#ifdef D10rsu
extern struct paraminfo Pdrsu[];
extern struct labelinfo Ldrsu[];
extern drsudin(), drsudout(), drsusnof(), drsusone(), drsugbulk();
extern dnumrsu(), drsusedit(), drsusbulk();
extern char *drsunof(), *drsunum();
#endif

#ifdef D10urp
extern struct paraminfo Pdurp[];
extern struct labelinfo Ldurp[];
extern durpdin(), durpdout(), durpsnof(), durpsone(), durpgbulk();
extern dnumurp(), durpsedit(), durpsbulk();
extern char *durpnof(), *durpnum();
#endif

#ifdef D10tra
extern struct paraminfo Pdtra[];
extern struct labelinfo Ldtra[];
extern dtradin(), dtradout(), dtrasnof(), dtrasone(), dtragbulk();
extern dnumtra(), dtrasedit(), dtrasbulk();
extern char *dtranof(), *dtranum();
#endif

#ifdef K1multi
extern struct paraminfo Pk1m[];
extern struct labelinfo Lk1m[];
extern k1mdin(), k1mdout(), k1msnof(), k1msone(), k1mgbulk();
extern k1nummlt(), k1msedit(), k1msbulk();
extern char *k1mnof(), *k1mnum();
#endif

#ifdef K1single
extern struct paraminfo Pk1sng[];
extern struct labelinfo Lk1sng[];
extern k1sdin(), k1sdout();
#ifndef K1multi
extern k1msnof(), k1msone(), k1mgbulk();
extern k1nummlt(), k1msedit(), k1msbulk();
extern char *k1mnof(), *k1mnum();
#endif
#endif

#ifdef DX7
extern struct paraminfo Pdx7[];
extern struct labelinfo Ldx7[];
extern dx7din(), dx7dout(), dx7snof(), dx7sedit(), dx7sbulk(), dx7gbulk();
extern char *dx7nof();
#endif

#ifdef DX7S
extern struct paraminfo Pdx7S[];
extern struct labelinfo Ldx7S[];
extern dx7Sdin(), dx7Sdout(), dx7snof(), dx7Ssedit(), dx7Ssbulk(), dx7Sgbulk();
extern char *dx7nof();

/* if the DX7s dataID is changed, it must be changed in readall() as well. */

#define DX7S_DATAID 0xd7
#endif

#ifdef CZ1
extern cz1din(), cz1dout(), cz1snof(), cz1sbulk(), cz1gbulk(),
       cz1sedit(), cz1sone();
extern char *cz1nof();
extern struct paraminfo Pcz1[];
extern struct labelinfo Lcz1[];
#endif


struct editinfo E[] = {

#ifdef MWAVE
   {"MicroWave Single", NULL, NULL, 64, 180, 16, 0,
	NULL, NULL, mspsedit, NULL, mspsbulk, mspgbulk, mspnof, mspsnof,
	mwvnum, NULL, NULL, mspfilein, mspfileout },
   {"MicroWave Multi", NULL, NULL, 64, 226, 16, 0,
	NULL, NULL, mmpsedit, NULL, mmpsbulk, mmpgbulk, mmpnof, mmpsnof,
	mwvnum, NULL, NULL, mmpfilein, mmpfileout },
   {"MicroWave User Waves", Pmuw, Lmuw, 61, 128, 16, 0,
	muwdin, muwdout, muwsedit, muwsone, muwsbulk, muwgbulk, muwnof, muwsnof,
	muwvnum, muwcvtnum, NULL, muwfilein, muwfileout },
   {"MicroWave Wavetables", Pmwt, Lmwt, 12, 256, 16, 0,
	mwtdin, mwtdout, mwtsedit, mwtsone, mwtsbulk, mwtgbulk, mwtnof, mwtsnof,
	mwtvnum, mwtcvtnum, NULL, mwtfilein, mwtfileout },
#endif
#ifdef DX100
   {"DX-100", Pdx100, Ldx100, 24, 128, 17, 0xdd,
	dxtxdin, dxtxdout, dx1sedit, NULL, dx1sbulk, dx1gbulk, dx1nof, dx1snof,
	NULL, NULL, NULL},
#endif
#ifdef DEP5
   {"DEP-5", Pdep5, Ldep5, 99, 42, 16, 0xdd,
	dep5din, dep5dout, dep5sedit, dep5sone, NULL, NULL, dep5nof, dep5snof,
	NULL, NULL, NULL},
#endif
#ifdef TX81Z
   {"TX81Z", Ptx81z, Ltx81z, 32, 128, 17, 0xdd,
	dxtxdin, dxtxdout, dx1sedit, NULL, dx1sbulk, dx1gbulk, dx1nof, dx1snof,
	NULL, NULL, NULL},
#endif
#ifdef TX81ZPERF
   {"TX81Z Performance", Ptx81p, Ltx81p, 24, 76, 17, 0xdd,
	tx8pdin, tx8pdout, tx8psedit, NULL, tx8psbulk, tx8pgbulk, tx8pnof,
	tx8psnof, NULL, NULL, NULL},
#endif
#ifdef DW8000
   {"DW8000", Pdw800, Ldw800, 64, 72, 17, 0xdd,
	dw8din, dw8dout, dw8sedit, dw8sone, NULL, dw8gbulk, dw8nof, dw8snof,
	dw8vnum, dw8numv, NULL},
#endif
#ifdef KAWAIK5
   {"K-5 Single", Pk5s, Lk5s, 48, 984, 8, 0xdd,
	k5sdin, k5sdout, k5ssedit, k5ssone, k5ssbulk, k5sgbulk,
	k5snof, k5ssnof, k5vnum, NULL, k5numv},
   {"K-5 Multi", Pk5m, Lk5m, 48, 352, 8, 0xdd,
	k5mdin, k5mdout, k5msedit, k5msone, k5msbulk, k5mgbulk,
	k5mnof, k5msnof, k5vnum, NULL, k5numv},
#endif
#ifdef D10pat
   {"Patches ", Pdpat, Ldpat, 128, 58, 16, PATDATAID,
	dpatdin, dpatdout, dpatsedit, dpatsone, dpatsbulk,
	dpatgbulk, dpatnof, dpatsnof, dpatnum, dnumpat, NULL},
#endif

#ifdef D10tim
   {"Timbres ", Pdtim, Ldtim, 128, 28, 1, TIMDATAID,
	dtimdin, dtimdout, dtimsedit, dtimsone, dtimsbulk,
	dtimgbulk, dtimnof, dtimsnof, dtimnum, dnumtim, NULL},
#endif

#ifdef D10wfg
   {"Tone WFG's", Pdwfg, Ldwfg, 64, 266, 10, TONDATAID,
	dwfgdin, dwfgdout, dtonsedit, dtonsone, dtonsbulk,
	dtongbulk, dtonnof, dtonsnof, dtonnum, dnumton, NULL},
#endif

#ifdef D10tvf
   {"Tone TVF's", Pdtvf, Ldtvf, 64, 266, 10, TONDATAID,
	dtvfdin, dtvfdout, dtonsedit, dtonsone, dtonsbulk,
	dtongbulk, dtonnof, dtonsnof, dtonnum, dnumton, NULL},
#endif

#ifdef D10tva
   {"Tone TVA's ", Pdtva, Ldtva, 64, 266, 10, TONDATAID,
	dtvadin, dtvadout, dtonsedit, dtonsone, dtonsbulk,
	dtongbulk, dtonnof, dtonsnof, dtonnum, dnumton, NULL},
#endif

#ifdef D10rsu
   {"Rhythm Setup ", Pdrsu, Ldrsu, 85, 24, 1, RSUDATAID,
	drsudin, drsudout, drsusedit, drsusone, drsusbulk,
	drsugbulk, drsunof, drsusnof, drsunum, dnumrsu, NULL},
#endif

#ifdef D10urp
   {"Rhythm Patterns ", Pdurp, Ldurp, 32, 608, 1, URPDATAID,
	durpdin, durpdout, durpsedit, durpsone, durpsbulk,
	durpgbulk, durpnof, durpsnof, durpnum, dnumurp, NULL},
#endif

#ifdef D10tra
   {"Rhythm Track ", Pdtra, Ldtra, 1, 522, 1, TRADATAID,
	dtradin, dtradout, dtrasedit, dtrasone, dtrasbulk,
	dtragbulk, dtranof, dtrasnof, dtranum, dnumtra, NULL},
#endif

#ifdef K1multi
   {"Multi Patches", Pk1m, Lk1m, 32, 75, 10, PATDATAID,
	k1mdin, k1mdout, k1msedit, k1msone, k1msbulk,
	k1mgbulk, k1mnof, k1msnof, k1mnum, NULL, k1nummlt},
#endif

#ifdef K1single
   {"Single Patches", Pk1sng, Lk1sng, 64, 87, 10, TONDATAID,
	k1sdin, k1sdout, k1msedit, k1msone, k1msbulk,
	k1mgbulk, k1mnof, k1msnof, k1mnum, NULL, k1nummlt},
#endif

#ifdef DX7
   {"DX7", Pdx7, Ldx7, 32, 128, 10, 0,
	dx7din, dx7dout, dx7sedit, NULL, dx7sbulk, dx7gbulk, dx7nof, dx7snof,
	NULL, NULL, NULL},
#endif
#ifdef DX7S
   {"DX7s", Pdx7S, Ldx7S, 32, 163, 10, DX7S_DATAID,
	dx7Sdin, dx7Sdout, dx7Ssedit, NULL, dx7Ssbulk, dx7Sgbulk, dx7nof,
        dx7snof,
	NULL, NULL, NULL},
#endif

#ifdef CZ1
   {"CZ1", Pcz1, Lcz1, 64, 144, 16, 0xdd,
    cz1din, cz1dout, cz1sedit, cz1sone, NULL, cz1gbulk, cz1nof, cz1snof,
 /* cz1sbulk() is defined, but we use cz1sone(). */
    NULL, NULL, NULL},
#endif


   {NULL,NULL,NULL,0,0,0,0,
    NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL}
};
