/*
 * GLIB - a Generic LIBrarian and editor for synths
 *
 * MicroWave support
 *
 * by Tim Thompson
 */

#include "glib.h"
#include <ctype.h>

char *visnum(), *vismwave();

/* This array contains arbitrary screen labels */
struct labelinfo Lmwt[] = {
3,28,"Wave Numbers",
5,14,"0    1    2    3    4    5    6    7    8    9",
7,8,"0",
8,7,"10",
9,7,"20",
10,7,"30",
11,7,"40",
12,7,"50",
13,7,"60",
16,0,"h = left   l = right   k = up",
16,34,"j = down",
17,0,"K = incr   J = decr    q = quit   <sp> = note",
18,0,"Pitch",
18,11,"Vol",
18,23,"Dur",
18,34,"Chan",
# line 22 "mwave2.mnu"
-1,-1,NULL
};

struct paraminfo  Pmwt[] =  {
/*
NAME		TYPE	POS	MAX	OFFSET	MASK	SHIFT	ADHOC
 */
"wave0",NULL,-1,-1,7,13,vismwave,0,506,0,0,
"wave1",NULL,-1,-1,7,18,vismwave,0,506,0,0,
"wave2",NULL,-1,-1,7,23,vismwave,0,506,0,0,
"wave3",NULL,-1,-1,7,28,vismwave,0,506,0,0,
"wave4",NULL,-1,-1,7,33,vismwave,0,506,0,0,
"wave5",NULL,-1,-1,7,38,vismwave,0,506,0,0,
"wave6",NULL,-1,-1,7,43,vismwave,0,506,0,0,
"wave7",NULL,-1,-1,7,48,vismwave,0,506,0,0,
"wave8",NULL,-1,-1,7,53,vismwave,0,506,0,0,
"wave9",NULL,-1,-1,7,58,vismwave,0,506,0,0,
"wave10",NULL,-1,-1,8,13,vismwave,0,506,0,0,
"wave11",NULL,-1,-1,8,18,vismwave,0,506,0,0,
"wave12",NULL,-1,-1,8,23,vismwave,0,506,0,0,
"wave13",NULL,-1,-1,8,28,vismwave,0,506,0,0,
"wave14",NULL,-1,-1,8,33,vismwave,0,506,0,0,
"wave15",NULL,-1,-1,8,38,vismwave,0,506,0,0,
"wave16",NULL,-1,-1,8,43,vismwave,0,506,0,0,
"wave17",NULL,-1,-1,8,48,vismwave,0,506,0,0,
"wave18",NULL,-1,-1,8,53,vismwave,0,506,0,0,
"wave19",NULL,-1,-1,8,58,vismwave,0,506,0,0,
"wave20",NULL,-1,-1,9,13,vismwave,0,506,0,0,
"wave21",NULL,-1,-1,9,18,vismwave,0,506,0,0,
"wave22",NULL,-1,-1,9,23,vismwave,0,506,0,0,
"wave23",NULL,-1,-1,9,28,vismwave,0,506,0,0,
"wave24",NULL,-1,-1,9,33,vismwave,0,506,0,0,
"wave25",NULL,-1,-1,9,38,vismwave,0,506,0,0,
"wave26",NULL,-1,-1,9,43,vismwave,0,506,0,0,
"wave27",NULL,-1,-1,9,48,vismwave,0,506,0,0,
"wave28",NULL,-1,-1,9,53,vismwave,0,506,0,0,
"wave29",NULL,-1,-1,9,58,vismwave,0,506,0,0,
"wave30",NULL,-1,-1,10,13,vismwave,0,506,0,0,
"wave31",NULL,-1,-1,10,18,vismwave,0,506,0,0,
"wave32",NULL,-1,-1,10,23,vismwave,0,506,0,0,
"wave33",NULL,-1,-1,10,28,vismwave,0,506,0,0,
"wave34",NULL,-1,-1,10,33,vismwave,0,506,0,0,
"wave35",NULL,-1,-1,10,38,vismwave,0,506,0,0,
"wave36",NULL,-1,-1,10,43,vismwave,0,506,0,0,
"wave37",NULL,-1,-1,10,48,vismwave,0,506,0,0,
"wave38",NULL,-1,-1,10,53,vismwave,0,506,0,0,
"wave39",NULL,-1,-1,10,58,vismwave,0,506,0,0,
"wave40",NULL,-1,-1,11,13,vismwave,0,506,0,0,
"wave41",NULL,-1,-1,11,18,vismwave,0,506,0,0,
"wave42",NULL,-1,-1,11,23,vismwave,0,506,0,0,
"wave43",NULL,-1,-1,11,28,vismwave,0,506,0,0,
"wave44",NULL,-1,-1,11,33,vismwave,0,506,0,0,
"wave45",NULL,-1,-1,11,38,vismwave,0,506,0,0,
"wave46",NULL,-1,-1,11,43,vismwave,0,506,0,0,
"wave47",NULL,-1,-1,11,48,vismwave,0,506,0,0,
"wave48",NULL,-1,-1,11,53,vismwave,0,506,0,0,
"wave49",NULL,-1,-1,11,58,vismwave,0,506,0,0,
"wave50",NULL,-1,-1,12,13,vismwave,0,506,0,0,
"wave51",NULL,-1,-1,12,18,vismwave,0,506,0,0,
"wave52",NULL,-1,-1,12,23,vismwave,0,506,0,0,
"wave53",NULL,-1,-1,12,28,vismwave,0,506,0,0,
"wave54",NULL,-1,-1,12,33,vismwave,0,506,0,0,
"wave55",NULL,-1,-1,12,38,vismwave,0,506,0,0,
"wave56",NULL,-1,-1,12,43,vismwave,0,506,0,0,
"wave57",NULL,-1,-1,12,48,vismwave,0,506,0,0,
"wave58",NULL,-1,-1,12,53,vismwave,0,506,0,0,
"wave59",NULL,-1,-1,12,58,vismwave,0,506,0,0,
"wave60",NULL,-1,-1,13,13,vismwave,0,506,0,0,
"autopitch",NULL,-1,-1,18,6,visnum,0,127,60,0,
"autovol",NULL,-1,-1,18,15,visnum,0,127,63,0,
"autodur",NULL,-1,-1,18,27,visnum,1,20,5,0,
"autochan",NULL,-1,-1,18,39,visnum,1,16,1,0,
NULL,NULL,-1,-1,-1,-1,visnum,0,0,0,0
};
