/* $Id: tx81z.mnu,v 1.6 89/05/06 17:13:45 lee Exp $
 * GLIB - a Generic LIBrarian and editor for synths
 *
 * TX81Z routines for Patch parameters
 * Tim Thompson
 * modifications: Greg Lee
 * $Log:	tx81z.mnu,v $
 * Revision 1.6  89/05/06  17:13:45  lee
 * rel. to comp.sources.misc
 * 
 */

#define OVERLAY1

#include "glib.h"
#include <ctype.h>

char *visnum(), *visonoff(), *vism3num(), *viswave(), *vismono();
char *visdx1a(), *vistxwave(), *vistxsft();
char *vistf1(), *vistf2(), *vistf3(), *vistf4();
char *visfx(), *visfx1(), *visfx2(), *visfx3(), *visfx4();
extern int Dopmap[];
void txinit(void);

#define RESERVESIZE 0

/* This array contains arbitrary screen labels */
struct labelinfo Ltx81z[] = {
1,49,"Algorithm",
2,49,"=============",
5,1,"O",
5,9,"Dcy Lev Dcy",
5,35,"De  Out",
5,47,"Amp Eg  Key Key EG",
6,1,"P   Atk  1   1   2  Rls Wav  Freq tun Lvl Vel Mod Bia Rat Scl Sft Fix/Ratio",
7,1,"-   --- --- --- --- --- --- ----- --- --- --- --- --- --- --- --- ---------",
8,1,"1",
9,1,"2",
10,1,"3",
11,1,"4",
13,11,"Reverb Rate",
13,33,"Feedback",
13,55,"Mono/Poly",
14,11,"FC Pitch",
14,33,"Transpose",
14,55,"Amp Mod Depth",
15,11,"FC Amp",
15,33,"LFO Speed",
15,55,"Amp Mod Sense",
16,33,"LFO Delay",
16,55,"Pitch Mod Depth",
17,0,"-------------------------+",
17,33,"LFO Wave",
17,55,"Pitch Mod Sense",
18,0,"N = set name  q = quit   |",
18,33,"LFO Sync",
18,55,"Mod Pitch Range",
19,0,"K = incr",
19,14,"J = decr   |",
19,33,"Pitch Bend",
19,55,"Mod Amp Range",
20,0,"space = play auto-note   |",
20,33,"Port. Time",
20,55,"Breath Pitch",
21,25,"|",
21,33,"Port. Mode",
21,55,"Breath Amp",
22,0,"Auto-Note: Pitch",
22,25,"|",
22,33,"Port. Foot",
22,55,"Breath Pitch Bias",
23,0,"Vol",
23,8,"Dur",
23,16,"Chan",
23,25,"|",
23,33,"Sus. Foot",
23,55,"Breath EG Bias",
# line 27 "tx81z.mnu"
-1,-1,NULL
};

struct paraminfo  Ptx81z[] =  {
/*
NAME		TYPE	POS	MAX	OFFSET	MASK	SHIFT	ADHOC
 */
"algorithm",NULL,-1,-1,1,61,visdx1a,0,7,0,0,
"op1attack",NULL,-1,-1,8,6,visnum,0,31,0,0,
"op1decay1",NULL,-1,-1,8,10,visnum,0,31,0,0,
"op1level1",NULL,-1,-1,8,14,visnum,0,15,0,0,
"op1decay2",NULL,-1,-1,8,18,visnum,0,31,0,0,
"op1release",NULL,-1,-1,8,22,visnum,0,31,0,0,
"op1wave",NULL,-1,-1,8,26,vistxwave,0,7,0,0,
"op1freq",NULL,-1,-1,8,30,vistf1,0,878,0,0,
"op1detune",NULL,-1,-1,8,36,vism3num,0,6,0,0,
"op1outlevel",NULL,-1,-1,8,40,visnum,0,99,0,0,
"op1velocity",NULL,-1,-1,8,44,visnum,0,7,0,0,
"op1ampmod",NULL,-1,-1,8,47,visonoff,0,1,0,0,
"op1egbias",NULL,-1,-1,8,52,visnum,0,7,0,0,
"op1keyrate",NULL,-1,-1,8,56,visnum,0,3,0,0,
"op1keyscale",NULL,-1,-1,8,60,visnum,0,99,0,0,
"op1egsft",NULL,-1,-1,8,63,vistxsft,0,3,0,0,
"op1fix",NULL,-1,-1,8,69,visfx1,0,1,0,0,
"op2attack",NULL,-1,-1,9,6,visnum,0,31,0,0,
"op2decay1",NULL,-1,-1,9,10,visnum,0,31,0,0,
"op2level1",NULL,-1,-1,9,14,visnum,0,15,0,0,
"op2decay2",NULL,-1,-1,9,18,visnum,0,31,0,0,
"op2release",NULL,-1,-1,9,22,visnum,0,31,0,0,
"op2wave",NULL,-1,-1,9,26,vistxwave,0,7,0,0,
"op2freq",NULL,-1,-1,9,30,vistf2,0,878,0,0,
"op2detune",NULL,-1,-1,9,36,vism3num,0,6,0,0,
"op2outlevel",NULL,-1,-1,9,40,visnum,0,99,0,0,
"op2velocity",NULL,-1,-1,9,44,visnum,0,7,0,0,
"op2ampmod",NULL,-1,-1,9,47,visonoff,0,1,0,0,
"op2egbias",NULL,-1,-1,9,52,visnum,0,7,0,0,
"op2keyrate",NULL,-1,-1,9,56,visnum,0,3,0,0,
"op2keyscale",NULL,-1,-1,9,60,visnum,0,99,0,0,
"op2egsft",NULL,-1,-1,9,63,vistxsft,0,3,0,0,
"op2fix",NULL,-1,-1,9,69,visfx2,0,1,0,0,
"op3attack",NULL,-1,-1,10,6,visnum,0,31,0,0,
"op3decay1",NULL,-1,-1,10,10,visnum,0,31,0,0,
"op3level1",NULL,-1,-1,10,14,visnum,0,15,0,0,
"op3decay2",NULL,-1,-1,10,18,visnum,0,31,0,0,
"op3release",NULL,-1,-1,10,22,visnum,0,31,0,0,
"op3wave",NULL,-1,-1,10,26,vistxwave,0,7,0,0,
"op3freq",NULL,-1,-1,10,30,vistf3,0,878,0,0,
"op3detune",NULL,-1,-1,10,36,vism3num,0,6,0,0,
"op3outlevel",NULL,-1,-1,10,40,visnum,0,99,0,0,
"op3velocity",NULL,-1,-1,10,44,visnum,0,7,0,0,
"op3ampmod",NULL,-1,-1,10,47,visonoff,0,1,0,0,
"op3egbias",NULL,-1,-1,10,52,visnum,0,7,0,0,
"op3keyrate",NULL,-1,-1,10,56,visnum,0,3,0,0,
"op3keyscale",NULL,-1,-1,10,60,visnum,0,99,0,0,
"op3egsft",NULL,-1,-1,10,63,vistxsft,0,3,0,0,
"op3fix",NULL,-1,-1,10,69,visfx3,0,1,0,0,
"op4decay1",NULL,-1,-1,11,6,visnum,0,31,0,0,
"op4attack",NULL,-1,-1,11,10,visnum,0,31,0,0,
"op4level1",NULL,-1,-1,11,14,visnum,0,15,0,0,
"op4decay2",NULL,-1,-1,11,18,visnum,0,31,0,0,
"op4release",NULL,-1,-1,11,22,visnum,0,31,0,0,
"op4wave",NULL,-1,-1,11,26,vistxwave,0,7,0,0,
"op4freq",NULL,-1,-1,11,30,vistf4,0,878,0,0,
"op4detune",NULL,-1,-1,11,36,vism3num,0,6,0,0,
"op4outlevel",NULL,-1,-1,11,40,visnum,0,99,0,0,
"op4velocity",NULL,-1,-1,11,44,visnum,0,7,0,0,
"op4ampmod",NULL,-1,-1,11,47,visonoff,0,1,0,0,
"op4egbias",NULL,-1,-1,11,52,visnum,0,7,0,0,
"op4keyrate",NULL,-1,-1,11,56,visnum,0,3,0,0,
"op4keyscale",NULL,-1,-1,11,60,visnum,0,99,0,0,
"op4egsft",NULL,-1,-1,11,63,vistxsft,0,3,0,0,
"op4fix",NULL,-1,-1,11,69,visfx4,0,1,0,0,
"feedback",NULL,-1,-1,13,24,visnum,0,7,0,0,
"playmode",NULL,-1,-1,13,45,vismono,0,1,0,0,
"reverbrate",NULL,-1,-1,13,74,visnum,0,7,0,0,
"transpose",NULL,-1,-1,14,24,visnum,0,45,0,0,
"amoddepth",NULL,-1,-1,14,45,visnum,0,99,0,0,
"fcpitch",NULL,-1,-1,14,74,visnum,0,99,0,0,
"lfospeed",NULL,-1,-1,15,24,visnum,0,99,0,0,
"amodsens",NULL,-1,-1,15,45,visnum,0,3,0,0,
"fcamp",NULL,-1,-1,15,74,visnum,0,99,0,0,
"lfodelay",NULL,-1,-1,16,45,visnum,0,99,0,0,
"pmoddepth",NULL,-1,-1,16,74,visnum,0,99,0,0,
"lfowave",NULL,-1,-1,17,45,viswave,0,3,0,0,
"pmodsens",NULL,-1,-1,17,74,visnum,0,7,0,0,
"lfosync",NULL,-1,-1,18,45,visonoff,0,1,0,0,
"modprange",NULL,-1,-1,18,74,visnum,0,99,0,0,
"pitchbend",NULL,-1,-1,19,45,visnum,0,12,0,0,
"modarange",NULL,-1,-1,19,74,visnum,0,99,0,0,
"portatime",NULL,-1,-1,20,45,visnum,0,99,0,0,
"breathprange",NULL,-1,-1,20,74,visnum,0,99,0,0,
"portmode",NULL,-1,-1,21,45,visnum,0,1,0,0,
"breatharange",NULL,-1,-1,21,74,visnum,0,99,0,0,
"autopitch",NULL,-1,-1,22,17,visnum,0,127,60,0,
"portfoot",NULL,-1,-1,22,45,visonoff,0,1,0,0,
"breathpbias",NULL,-1,-1,22,74,visnum,0,99,0,0,
"autochan",NULL,-1,-1,23,4,visnum,1,16,1,0,
"autodur",NULL,-1,-1,23,12,visnum,1,20,5,0,
"autovol",NULL,-1,-1,23,21,visnum,0,127,63,0,
"susfoot",NULL,-1,-1,23,45,visonoff,0,1,0,0,
"breathegbias",NULL,-1,-1,23,74,visnum,0,99,0,0,
NULL,NULL,-1,-1,-1,-1,visnum,0,0,0,0
};


extern int *txindex;
extern int txleng;

char *
vistxwave(int v)
{
	static char txbuff[3] = "W ";
	txbuff[1] = v + '1';
	return(txbuff);
}

char *visfx1(int v) { return(visfx(1,v)); }
char *visfx2(int v) { return(visfx(2,v)); }
char *visfx3(int v) { return(visfx(3,v)); }
char *visfx4(int v) { return(visfx(4,v)); }

char *visfx(int n,int v)
{
	static int lastfx[] = { 0, -1, -1, -1, -1 };
	char buff2[8];
	int fqindex;

	if ( lastfx[n] != -1 && lastfx[n] == v )
		goto nochange;

	lastfx[n] = v;
	sprintf(buff2,"op%dfreq",n);
	fqindex = parmindex(buff2);
	if ( v == 0 )
		P[fqindex].p_max = txleng-1;
	else
		P[fqindex].p_max = 247;
	if ( P[fqindex].p_val > P[fqindex].p_max )
		P[fqindex].p_val = P[fqindex].p_max;
	showparam(fqindex,0);
nochange:
	if ( v == 0 )
		return("ratio");
	else
		return("fixed");
}

char *
vistxsft(int v)
{
	switch(v){
	case 0: return("off");
	case 1: return("48");
	case 2: return("24");
	case 3: return("12");
	}
	return("??");
}

extern int txfreq[];

char *
vistxq(int v)
{
	static char fbuff[8];
	int f, n1, n2;

	txinit();
	f = txfreq[txindex[v]];
	n1 = f/100;
	n2 = f%100;
	sprintf(fbuff,n2<10?"%d.0%d":"%d.%d",n1,n2);
	return(fbuff);
}

char *
visfq(int v)
{
	static char fixbuff[8];

	sprintf(fixbuff,"%-5d",v+8);
	return(fixbuff);
}

char *
visnfix(int n,int v)
{
	char buff[8];
	int fx;

	sprintf(buff,"op%dfix",n);
	fx = getval(buff);
	if ( fx == 0 )
		return(vistxq(v));
	else
		return(visfq(v));
}

char *vistf1(int v) { return(visnfix(1,v)); }
char *vistf2(int v) { return(visnfix(2,v)); }
char *vistf3(int v) { return(visnfix(3,v)); }
char *vistf4(int v) { return(visnfix(4,v)); }
