/* $Id: vis.c,v 1.6 89/05/06 17:13:46 lee Exp $
 * GLIB - a Generic LIBrarian and editor for synths
 *
 * Data Display Routines
 *
 * Code started 16 JAN 89 --  Michael R. Kesti mrk@gvgspd.GVG.TEK.COM
 * $Log:	vis.c,v $
 * Revision 1.6  89/05/06  17:13:46  lee
 * rel. to comp.sources.misc
 * 
 */

#include <stdio.h>
#include <string.h>
#include <math.h>

char *
vispan(int v)
{
	switch (v) {
	case 0: return("7>");
	case 1: return("6>");
	case 2: return("5>");
	case 3: return("4>");
	case 4: return("3>");
	case 5: return("2>");
	case 6: return("1>");
	case 7: return("><");
	case 8: return("<1");
	case 9: return("<2");
	case 10: return("<3");
	case 11: return("<4");
	case 12: return("<5");
	case 13: return("<6");
	case 14: return("<7");
	}
	return("*");
}

char *
visreverbtype(int v)
{
	switch (v) {
	case 0: return("ROOM 1");
	case 1: return("ROOM 2");
	case 2: return("HALL 1");
	case 3: return("HALL 2");
	case 4: return("PLATE");
	case 5: return("DELAY 1");
	case 6: return("DELAY 2");
	case 7: return("DELAY 3");
	case 8: return("OFF");
	}
	return("*");
}

char *
visreverbtime(int v)
{
	static char visreverbtimebuf[2];

	if((v >= 0) && (v <= 7)) {
		sprintf(visreverbtimebuf,"%d",v + 1);
		return(visreverbtimebuf);
	} else {
		return("*");
	}
}

char *
visreverblevel(int v)
{
	static char visreverblevelbuf[2];

	if((v >= 0) && (v <= 7)) {
		sprintf(visreverblevelbuf,"%d",v);
		return(visreverblevelbuf);
	} else {
		return("*");
	}
}

char *
vispatchlevel(int v)
{
	static char vispatchlevelbuf[4];

	if((v >= 0) && (v <= 100)) {
		sprintf(vispatchlevelbuf,"%d",v);
		return(vispatchlevelbuf);
	} else {
		return("*");
	}
}

char *
viskeymode(int v)
{
	switch (v) {
	case 0: return("WHOLE");
	case 1: return("DUAL");
	case 2: return("SPLIT");
	}
	return("*");
}

static	char *split_table[] = {
	"C",
	"C#",
	"D",
	"D#",
	"E",
	"F",
	"F#",
	"G",
	"G#",
	"A",
	"A#",
	"B"
};

char *
vissplit(int v)
{
	static	char	vissplitbuf[4];

	if((v >= 0) && (v <= 61)) {
		strcpy(vissplitbuf, split_table[v % 12]);
		if(strlen(vissplitbuf) == 1) {
			vissplitbuf[1] = (((v / 12) + 2) + '0');
			vissplitbuf[2] = 0;
		} else {
			vissplitbuf[2] = (((v / 12) + 2) + '0');
			vissplitbuf[3] = 0;
		}
		return(vissplitbuf);
	} else {
	return("*");
	}
}

char *
vistonegroup(v)
{
	switch (v) {
	case 0: return("A");
	case 1: return("B");
	case 2: return("I");
	case 3: return("R");
	}
	return("*");
}

char *
visrtone(int v)
{
	static char visrtonebuf[4];

	if(v >= 0 && v <= 127) {
		if(v < 64) {
			sprintf(visrtonebuf,"% 02d",v + 1);
			visrtonebuf[0] = 'I';
		} else {
			if(v == 127) {
				strcpy(visrtonebuf, "OFF");
			} else {
				v -= 64;
				sprintf(visrtonebuf," %02d",v + 1);
				visrtonebuf[0] = 'R';
			}
		}
		return(visrtonebuf);
	}
	return("*");
}

char *
vistonenum(int v)
{
	static char vistonenumbuf[3];

	if((v >= 0) && (v <= 63)) {
		sprintf(vistonenumbuf,"%02d",v + 1);
		return(vistonenumbuf);
	} else {
		return("*");
	}
}

char *
viskeyshift(int v)
{
	static char viskeyshiftbuf[4];

	if((v >= 0) && (v <= 23)) {
		sprintf(viskeyshiftbuf,"-%d",abs(v - 24));
		return(viskeyshiftbuf);
	} else if(v == 24) {
		sprintf(viskeyshiftbuf,"0");
		return(viskeyshiftbuf);
	} else if((v >= 25) && (v <= 48)) {
		sprintf(viskeyshiftbuf,"+%d", (v - 24));
		return(viskeyshiftbuf);
	} else {
		return("*");
	}
}

char *
visfinetune(int v)
{
	static char visfinetunebuf[4];

	if((v >= 0) && (v <= 49)) {
		sprintf(visfinetunebuf,"-%d",abs(v - 50));
		return(visfinetunebuf);
	} else if(v == 50) {
		sprintf(visfinetunebuf,"0");
		return(visfinetunebuf);
	} else if((v >= 51) && (v <= 100)) {
		sprintf(visfinetunebuf,"+%d",(v - 50));
		return(visfinetunebuf);
	} else {
		return("*");
	}
}

char *
visbendrange(int v)
{
	static char visbendrangebuf[3];

	if((v >= 0) && (v <= 24)) {
		sprintf(visbendrangebuf,"%d",v);
		return(visbendrangebuf);
	} else {
		return("*");
	}
}

char *
visassignmode(int v)
{
	static char visassignmodebuf[2];

	if((v >= 0) && (v <= 3)) {
		sprintf(visassignmodebuf,"%d",v);
		return(visassignmodebuf);
	} else {
		return("*");
	}
}

char *
vistonebal(int v)
{
	static char vistonebalbuf[30];
	static char vistonebalbuf1[30];
	int n;

	if((v >= 0) && (v <= 100)) {
		sprintf(vistonebalbuf,"%d", v);
		for(n = 0 ; n < (int)(30 - strlen(vistonebalbuf)) ; n++)
			strcat(vistonebalbuf, " ");
		sprintf(vistonebalbuf1,"%d", abs(v - 100));
		strcat(vistonebalbuf, vistonebalbuf1);
		return(vistonebalbuf);
	} else {
		return("*");
	}
}

char *
visstruct(int v)
{
	if((v >= 0) && (v <= 12)) {
		switch(v) {
			case 0:
				return("~l~l~u~u~u __|_ ~d~l~l~l~l~l~l|    |~d~l~l~l~l~l~l|    |~d~l~l~l~l~l~lS 1  S");
				break;
			case 1:
				return("~l~l~u~u~u __|  ~d~l~l~l~l~l~l| RM  ~d~l~l~l~l~l~l|/  \\ ~d~l~l~l~l~l~lS 2  S");
				break;
			case 2:
				return("~l~l~u~u~u __|_ ~d~l~l~l~l~l~l|    |~d~l~l~l~l~l~l|    |~d~l~l~l~l~l~lP 3  S");
				break;
			case 3:
				return("~l~l~u~u~u __|  ~d~l~l~l~l~l~l| RM  ~d~l~l~l~l~l~l|/  \\ ~d~l~l~l~l~l~lP 4  S");
				break;
			case 4:
				return("~l~l~u~u~u __|  ~d~l~l~l~l~l~l| RM  ~d~l~l~l~l~l~l|/  \\ ~d~l~l~l~l~l~lS 5  P");
				break;
			case 5:
				return("~l~l~u~u~u __|_ ~d~l~l~l~l~l~l|    |~d~l~l~l~l~l~l|    |~d~l~l~l~l~l~lP 6  P");
				break;
			case 6:
				return("~l~l~u~u~u __|  ~d~l~l~l~l~l~l| RM  ~d~l~l~l~l~l~l|/  \\ ~d~l~l~l~l~l~lP 7  P");
				break;
			case 7:
				return("~l~l~u~u~u|    |~d~l~l~l~l~l~l|    |~d~l~l~l~l~l~l|    |~d~l~l~l~l~l~lS 8  S");
				break;
			case 8:
				return("~l~l~u~u~u|    |~d~l~l~l~l~l~l|    |~d~l~l~l~l~l~l|    |~d~l~l~l~l~l~lP 9  P");
				break;
			case 9:
				return("~l~l~u~u~u   |  ~d~l~l~l~l~l~l  RM  ~d~l~l~l~l~l~l /  \\ ~d~l~l~l~l~l~lS 10 S");
				break;
			case 10:
				return("~l~l~u~u~u   |  ~d~l~l~l~l~l~l  RM  ~d~l~l~l~l~l~l /  \\ ~d~l~l~l~l~l~lP 11 S");
				break;
			case 11:
				return("~l~l~u~u~u   |  ~d~l~l~l~l~l~l  RM  ~d~l~l~l~l~l~l /  \\ ~d~l~l~l~l~l~lS 12 P");
				break;
			case 12:
				return("~l~l~u~u~u   |  ~d~l~l~l~l~l~l  RM  ~d~l~l~l~l~l~l /  \\ ~d~l~l~l~l~l~lP 13 P");
				break;
		}
	} else {
		return("*");
	}
}

char *
vispmute(int v)
{
	switch (v) {
	case 0: return("_    _    _    _");
	case 1: return("1    _    _    _");
	case 2: return("_    2    _    _");
	case 3: return("1    2    _    _");
	case 4: return("_    _    3    _");
	case 5: return("1    _    3    _");
	case 6: return("_    2    3    _");
	case 7: return("1    2    3    _");
	case 8: return("_    _    _    4");
	case 9: return("1     _   _    4");
	case 10: return("_    2    _    4");
	case 11: return("1    2    _    4");
	case 12: return("_    _    3    4");
	case 13: return("1    _    3    4");
	case 14: return("_    2    3    4");
	case 15: return("1    2    3    4");
	}
	return("*");
}

char *
visenvmode(int v)
{
	switch (v) {
	case 0: return("NORMAL");
	case 1: return("NO SUSTAIN");
	}
	return("*");
}

static	char *cpitch_table[] = {
	"C",
	"C#",
	"D",
	"D#",
	"E",
	"F",
	"F#",
	"G",
	"G#",
	"A",
	"A#",
	"B"
};

char *
viscpitch(int v)
{
	static	char	viscpitchbuf[4];

	if((v >= 0) && (v <= 96)) {
		strcpy(viscpitchbuf, cpitch_table[v % 12]);
		if(strlen(viscpitchbuf) == 1) {
			viscpitchbuf[1] = (((v / 12) + 1) + '0');
			viscpitchbuf[2] = 0;
		} else {
			viscpitchbuf[2] = (((v / 12) + 1) + '0');
			viscpitchbuf[3] = 0;
		}
		return(viscpitchbuf);
	} else {
	return("*");
	}
}

char *
vispkeyfol(int v)
{
	switch (v) {
	case 0: return("-1");
	case 1: return("-1/2");
	case 2: return("-1/4");
	case 3: return("0");
	case 4: return("1/8");
	case 5: return("1/4");
	case 6: return("3/8");
	case 7: return("1/2");
	case 8: return("5/8");
	case 9: return("3/4");
	case 10: return("7/8");
	case 11: return("1");
	case 12: return("5/4");
	case 13: return("3/2");
	case 14: return("2");
	case 15: return("s1");
	case 16: return("s2");
	}
	return("*");
}

char *
vistkeyfol(int v)
{
	switch (v) {
	case 0: return("-1");
	case 1: return("-1/2");
	case 2: return("-1/4");
	case 3: return("0");
	case 4: return("1/8");
	case 5: return("1/4");
	case 6: return("3/8");
	case 7: return("1/2");
	case 8: return("5/8");
	case 9: return("3/4");
	case 10: return("7/8");
	case 11: return("1");
	case 12: return("5/4");
	case 13: return("3/2");
	case 14: return("2");
	}
	return("*");
}

char *
viswavebank(int v)
{
	switch (v) {
	case 0: return("SQU1");
	case 1: return("SAW1");
	case 2: return("SQU2");
	case 3: return("SAW2");
	}
	return("*");
}

char *
vispcmnum(int v)
{
	static char vispcmnumbuf[3];

	if((v >= 0) && (v <= 127)) {
		sprintf(vispcmnumbuf,"%d",v + 1);
		return(vispcmnumbuf);
	} else {
		return("*");
	}
}

char *
visvelsens(int v)
{
	static char visvelsensbuf[3];

	if((v >= 0) && (v <= 6)) {
		sprintf(visvelsensbuf,"-%d",abs(v - 7));
		return(visvelsensbuf);
	} else if(v == 7) {
		sprintf(visvelsensbuf,"0");
		return(visvelsensbuf);
	} else if((v >= 8) && (v <= 14)) {
		sprintf(visvelsensbuf,"+%d",abs(v - 7));
		return(visvelsensbuf);
	} else {
		return("*");
	}
}

char *
visenvlev(int v)
{
	static char visenvlevbuf[4];

	if((v >= 0) && (v <= 49)) {
		sprintf(visenvlevbuf,"-%d",abs(v - 50));
		return(visenvlevbuf);
	} else if(v == 50) {
		sprintf(visenvlevbuf,"0");
		return(visenvlevbuf);
	} else if((v >= 51) && (v <= 100)) {
		sprintf(visenvlevbuf,"+%d",abs(v - 50));
		return(visenvlevbuf);
	} else {
		return("*");
	}
}

char *
visbiaslev(int v)
{
	static char visbiaslevbuf[3];

	if((v >= 0) && (v <= 6)) {
		sprintf(visbiaslevbuf,"-%d",abs(v - 7));
		return(visbiaslevbuf);
	} else if(v == 7) {
		sprintf(visbiaslevbuf,"0");
		return(visbiaslevbuf);
	} else if((v >= 8) && (v <= 14)) {
		sprintf(visbiaslevbuf,"+%d",abs(v - 7));
		return(visbiaslevbuf);
	} else {
		return("*");
	}
}

static	char *bpitch_table[] = {
	"A",
	"A#",
	"B",
	"C",
	"C#",
	"D",
	"D#",
	"E",
	"F",
	"F#",
	"G",
	"G#"
};

char *
visbiaspd(int v)
{
	static	char	visbiaspdbuf[5];
	static	char	visbiaspdbuf1[2];

	if((v >= 0) && (v <= 127)) {
		if(v >= 64) {
			strcpy(visbiaspdbuf, ">");
			v -= 64;
		} else {
			strcpy(visbiaspdbuf, "<");
		}
		strcat(visbiaspdbuf, bpitch_table[v % 12]);
		v += 9;
		sprintf(visbiaspdbuf1, "%d", (v / 12) + 1);
		strcat(visbiaspdbuf, visbiaspdbuf1);
		return(visbiaspdbuf);
	} else {
		return("*");
	}
}

char *
vistvablev(int v)
{
	static char vistvablevbuf[4];

	if((v >= 0) && (v <= 12)) {
		if(v == 12) {
			return("0");
		} else {
			sprintf(vistvablevbuf,"-%d",abs(v - 12));
			return(vistvablevbuf);
		}
	} else {
		return("*");
	}
}

/* end */
