/* $Id: yama_com.c,v 1.6 89/05/06 17:13:47 lee Exp $
 * GLIB - a Generic LIBrarian and editor for synths
 *
 * Yamaha Common Routines
 * Tim Thompson
 * modifications: Greg Lee
 * $Log:	yama_com.c,v $
 * Revision 1.6  89/05/06  17:13:47  lee
 * rel. to comp.sources.misc
 * 
 */

#define OVERLAY1

#include "glib.h"
#include <ctype.h>

#define DX100VSIZE 128
#define DX100NSIZE 17

char *visnum(), *visonoff(), *vism3num(), *viswave(), *vismono();
char *visfreq(), *visdx1a();
extern int Tx81;

void setopval(int n,char *str,int v);
int getopval(int n,char *str);
void freqout(int v,int *acrs,int *afin);
void vmtovced(char *data,char *vdata);
void setdxtx(void);
void dxtxdout(char *data);
void txinit(void);
void dxtxdin(char *data);
int freqin(int crs,int fin);
void sendaced(char *data);
void vmtoaced(char *data,char *adata);

int *txindex = NULL;
int txleng = 0;


extern int Dopmap[];

int Tx81 = 0;	/* 1 means we're talking to the TX81Z */
int Dopmap[] = { 3,1,2,0 };

int txfreq[] = {
50, 56, 62, 69, 75, 81, 87, 93,
     100, 106, 112, 118, 124, 131, 137, 143,
71, 80, 88, 97, 106, 115, 123, 132,
     141, 149, 158, 167, 176, 184, 193, 202,
78, 88, 98, 107, 117, 127, 137, 147,
     156, 166, 176, 186, 196, 205, 215, 225,
87, 98, 108, 119, 130, 141, 151, 162,
     173, 183, 194, 205, 216, 226, 237, 248,
100, 106, 112, 119, 125, 131, 137, 143,
     149, 156, 162, 168, 174, 180, 187, 193,
141, 150, 159, 167, 176, 185, 194, 203,
     211, 220, 229, 238, 247, 255, 264, 273,
157, 167, 177, 186, 196, 206, 216, 226,
     235, 245, 255, 265, 275, 284, 294, 304,
173, 184, 195, 205, 216, 227, 238, 249,
     259, 270, 281, 292, 303, 313, 324, 335,
200, 206, 212, 218, 225, 231, 237, 243,
     249, 256, 262, 268, 274, 280, 287, 293,
282, 291, 300, 308, 317, 326, 335, 344,
     352, 361, 370, 379, 388, 396, 405, 414,
300, 306, 312, 318, 325, 331, 337, 343,
     349, 356, 362, 368, 374, 380, 387, 393,
314, 324, 334, 343, 353, 363, 373, 383,
     392, 402, 412, 422, 432, 441, 451, 461,
346, 357, 368, 378, 389, 400, 411, 422,
     432, 443, 454, 465, 476, 486, 497, 508,
400, 406, 412, 418, 425, 431, 437, 443,
     449, 456, 462, 468, 474, 480, 487, 493,
424, 433, 441, 450, 459, 468, 476, 485,
     494, 503, 511, 520, 529, 537, 546, 555,
471, 481, 491, 500, 510, 520, 530, 539,
     549, 559, 569, 579, 588, 598, 608, 618,
500, 506, 512, 519, 525, 531, 537, 543,
     550, 556, 562, 568, 574, 581, 587, 593,
519, 530, 540, 551, 562, 573, 584, 594,
     605, 616, 627, 638, 648, 659, 670, 681,
565, 574, 582, 591, 600, 609, 617, 626,
     635, 644, 652, 661, 670, 678, 687, 696,
600, 606, 612, 619, 625, 631, 637, 643,
     650, 656, 662, 668, 674, 681, 687, 693,
628, 638, 647, 657, 667, 677, 687, 696,
     706, 716, 726, 736, 745, 755, 765, 775,
692, 703, 713, 724, 735, 746, 757, 767,
     778, 789, 800, 811, 821, 832, 843, 854,
700, 706, 712, 719, 725, 731, 737, 743,
     750, 756, 762, 768, 774, 781, 787, 793,
707, 716, 724, 733, 742, 750, 759, 768,
     776, 785, 794, 802, 811, 820, 828, 837,
785, 795, 804, 814, 824, 834, 844, 853,
     863, 873, 883, 893, 902, 912, 922, 932,
800, 806, 812, 819, 825, 831, 837, 843,
     850, 856, 862, 868, 874, 881, 887, 893,
848, 857, 865, 874, 883, 891, 900, 909,
     917, 926, 935, 943, 952, 961, 969, 978,
865, 876, 886, 897, 908, 919, 930, 940,
     951, 962, 973, 984, 994, 1005, 1016, 1027,
900, 906, 912, 919, 925, 931, 937, 943,
     950, 956, 962, 968, 974, 981, 987, 993,
942, 952, 961, 971, 981, 991, 1001, 1010,
     1020, 1030, 1040, 1050, 1059, 1069, 1079, 1089,
989, 998, 1006, 1015, 1024, 1032, 1041, 1050,
     1058, 1067, 1076, 1084, 1093, 1102, 1110, 1119,
1000, 1006, 1012, 1019, 1025, 1031, 1037, 1043,
     1050, 1056, 1062, 1068, 1074, 1081, 1087, 1093,
1038, 1049, 1060, 1070, 1081, 1092, 1103, 1113,
     1124, 1135, 1146, 1157, 1167, 1178, 1189, 1200,
1099, 1109, 1119, 1128, 1138, 1148, 1158, 1167,
     1177, 1187, 1197, 1207, 1216, 1226, 1236, 1246,
1100, 1106, 1112, 1119, 1125, 1131, 1137, 1143,
     1150, 1156, 1162, 1168, 1174, 1181, 1187, 1193,
1130, 1139, 1147, 1156, 1165, 1173, 1182, 1191,
     1199, 1208, 1217, 1225, 1234, 1243, 1251, 1260,
1200, 1206, 1212, 1219, 1225, 1231, 1237, 1243,
     1250, 1256, 1262, 1268, 1274, 1281, 1287, 1293,
1211, 1222, 1233, 1243, 1254, 1265, 1276, 1286,
     1297, 1308, 1319, 1330, 1340, 1351, 1362, 1373,
1256, 1266, 1276, 1285, 1295, 1305, 1315, 1324,
     1334, 1344, 1354, 1364, 1373, 1383, 1393, 1403,
1272, 1281, 1289, 1298, 1306, 1315, 1323, 1332,
     1341, 1349, 1358, 1366, 1375, 1384, 1392, 1401,
1300, 1306, 1312, 1319, 1325, 1331, 1337, 1343,
     1350, 1356, 1362, 1368, 1374, 1381, 1387, 1393,
1384, 1395, 1406, 1416, 1427, 1438, 1449, 1459,
     1470, 1481, 1492, 1503, 1513, 1524, 1535, 1546,
1400, 1406, 1412, 1419, 1425, 1431, 1437, 1443,
     1450, 1456, 1462, 1468, 1474, 1481, 1487, 1493,
1410, 1419, 1428, 1436, 1445, 1454, 1463, 1471,
     1480, 1489, 1498, 1507, 1515, 1524, 1533, 1542,
1413, 1423, 1433, 1442, 1452, 1462, 1472, 1481,
     1491, 1501, 1511, 1521, 1530, 1540, 1550, 1560,
1500, 1506, 1512, 1519, 1525, 1531, 1537, 1543,
     1550, 1556, 1562, 1568, 1574, 1581, 1587, 1593,
1555, 1563, 1572, 1581, 1589, 1598, 1606, 1615,
     1623, 1632, 1640, 1649, 1657, 1666, 1674, 1683,
1557, 1568, 1579, 1589, 1600, 1611, 1622, 1632,
     1643, 1654, 1665, 1676, 1686, 1697, 1708, 1719,
1570, 1580, 1590, 1599, 1609, 1619, 1629, 1638,
     1648, 1658, 1668, 1678, 1687, 1697, 1707, 1717,
1696, 1704, 1713, 1722, 1730, 1739, 1747, 1756,
     1764, 1773, 1781, 1790, 1798, 1807, 1815, 1824,
1727, 1737, 1747, 1756, 1766, 1776, 1786, 1795,
     1805, 1815, 1825, 1835, 1844, 1854, 1864, 1874,
1730, 1741, 1752, 1762, 1773, 1784, 1795, 1805,
     1816, 1827, 1838, 1849, 1859, 1870, 1881, 1892,
1837, 1845, 1854, 1863, 1871, 1880, 1888, 1897,
     1905, 1914, 1922, 1931, 1939, 1948, 1956, 1965,
1884, 1894, 1904, 1913, 1923, 1933, 1943, 1952,
     1962, 1972, 1982, 1992, 2001, 2011, 2021, 2031,
1903, 1914, 1925, 1935, 1946, 1957, 1968, 1978,
     1989, 2000, 2011, 2022, 2032, 2043, 2054, 2065,
1978, 1986, 1995, 2004, 2012, 2021, 2029, 2038,
     2046, 2055, 2063, 2072, 2080, 2089, 2097, 2106,
2041, 2051, 2061, 2070, 2080, 2090, 2100, 2110,
     2119, 2129, 2139, 2149, 2159, 2168, 2178, 2188,
2076, 2087, 2098, 2108, 2119, 2130, 2141, 2152,
     2162, 2173, 2184, 2195, 2206, 2216, 2227, 2238,
2120, 2128, 2137, 2145, 2154, 2162, 2171, 2179,
     2188, 2196, 2205, 2213, 2222, 2230, 2238, 2247,
2198, 2208, 2218, 2227, 2237, 2247, 2257, 2267,
     2276, 2286, 2296, 2306, 2316, 2325, 2335, 2345,
2249, 2260, 2271, 2281, 2292, 2303, 2314, 2325,
     2335, 2346, 2357, 2368, 2379, 2389, 2400, 2411,
2355, 2365, 2375, 2384, 2394, 2404, 2414, 2424,
     2433, 2443, 2453, 2463, 2473, 2482, 2492, 2502,
2422, 2433, 2444, 2454, 2465, 2476, 2487, 2498,
     2508, 2519, 2530, 2541, 2552, 2562, 2573, 2584,
2595, 2606, 2617, 2627, 2638, 2649, 2660, 2671,
     2681, 2692, 2703, 2714, 2725, 2735, 2746, 2757
};

/*
 * dxtxdin
 *
 * Take info from 'data' and stuff values in the P array, by using
 * the setval (and setopval) functions.  'data' is the Yamaha VMEM format.
 * This function works for both the dx100 and tx81z.
 */

void
dxtxdin(char *data)
{
	int dop, adop, n, crs, fin, v;

	setdxtx();
	if ( Tx81 )
		txinit();
	for ( n=1; n<=4; n++ ) {
		dop = Dopmap[n-1]*10;
		adop = Dopmap[n-1]*2;
		setopval(n,"attack",data[0+dop]);
		setopval(n,"decay1",data[1+dop]);
		setopval(n,"level1",data[4+dop]);
		setopval(n,"decay2",data[2+dop]);
		setopval(n,"release",data[3+dop]);
		setopval(n,"keyscale",data[5+dop]);
		setopval(n,"ampmod",(data[6+dop]>>6)&01);
		setopval(n,"egbias",(data[6+dop]>>3)&07);
		setopval(n,"velocity",data[6+dop]&07);
		setopval(n,"outlevel",data[7+dop]);

		if ( Tx81 ) {
			crs = data[8+dop];
			fin = (data[74+adop]) & 017;
			v = freqin(crs,fin);
			setopval(n,"freq",v);
		}
		else
			setopval(n,"freq",data[8+dop]);

		setopval(n,"keyrate",data[9+dop]>>3);
		setopval(n,"detune",data[9+dop]&07);

		if ( Tx81 ) {
			setopval(n,"egsft",(data[73+adop]>>4)&03);
			setopval(n,"fix",(data[73+adop]>>3)&01);
			setopval(n,"wave",(data[74+adop]>>4)&07);
		}
	}
	setval("lfosync",(data[40]>>6)&01);
	setval("feedback",(data[40]>>3)&07);
	setval("algorithm",data[40]&07);
	setval("lfospeed",data[41]);
	setval("lfodelay",data[42]);
	setval("pmoddepth",data[43]);
	setval("amoddepth",data[44]);
	setval("pmodsens",(data[45]>>4)&07);
	setval("amodsens",(data[45]>>2)&03);
	setval("lfowave",data[45]&03);
	setval("transpose",data[46]);
	setval("pitchbend",data[47]);
	setval("portatime",data[49]);
	setval("modprange",data[51]);
	setval("modarange",data[52]);
	setval("breathprange",data[53]);
	setval("breatharange",data[54]);
	setval("breathpbias",data[55]);
	setval("breathegbias",data[56]);
	setval("playmode",(data[48]>>3)&01);
	setval("susfoot",(data[48]>>2)&01);
	setval("portfoot",(data[48]>>1)&01);
	setval("portmode",data[48]&01);
	setval("autochan",Channel);
	if ( Tx81 ) {
		setval("reverbrate",data[81]&07);
		setval("fcpitch",data[82]);
		setval("fcamp",data[83]);
	}
}

/*
 * dxtxdout
 *
 * Take (possibly changed) parameters values out of the P array and
 * put them back into 'data'.  'data' is in the Yamaha VMEM format.
 * This works for both the dx100 and tx81z.
 */

void
dxtxdout(char *data)
{
	int dop, n, crs, fin;

	for ( n=1; n<=4; n++ ) {
		dop = Dopmap[n-1]*10;
		data[0+dop] = getopval(n,"attack");
		data[1+dop] = getopval(n,"decay1");
		data[4+dop] = getopval(n,"level1");
		data[2+dop] = getopval(n,"decay2");
		data[3+dop] = getopval(n,"release");
		data[5+dop] = getopval(n,"keyscale");
		data[6+dop] = getopval(n,"ampmod")<<6
				| getopval(n,"egbias")<<3
				| getopval(n,"velocity");
		data[7+dop] = getopval(n,"outlevel");
		data[9+dop] = getopval(n,"keyrate")<<3 | getopval(n,"detune");

		if ( ! Tx81 ) {
			data[8+dop] = getopval(n,"freq");
		}
		else {
			freqout(getopval(n,"freq"),&crs,&fin);
			data[8+dop] = crs;

			dop = Dopmap[n-1]*2;
			data[73+dop] = getopval(n,"egsft")<<4
					| getopval(n,"fix")<<3
					/* | getopval(n,"fixrg") */;
			data[74+dop] = getopval(n,"wave")<<4 | fin;
		}
	}
	data[40] = getval("lfosync")<<6
		| getval("feedback")<<3
		| getval("algorithm");
	data[41] = getval("lfospeed");
	data[42] = getval("lfodelay");
	data[43] = getval("pmoddepth");
	data[44] = getval("amoddepth");
	data[45] = getval("pmodsens")<<4 | getval("amodsens")<<2
		| getval("lfowave");
	data[46] = getval("transpose");
	data[47] = getval("pitchbend");
	data[49] = getval("portatime");
	data[51] = getval("modprange");
	data[52] = getval("modarange");
	data[53] = getval("breathprange");
	data[54] = getval("breatharange");
	data[55] = getval("breathpbias");
	data[56] = getval("breathegbias");
	data[48] = (unsigned) ( getval("playmode")<<3
		| getval("susfoot")<<2
		| getval("portfoot")<<1
		| getval("portmode"));

	if ( Tx81 ) {
		data[81] = getval("reverbrate");
		data[82] = getval("fcpitch");
		data[83] = getval("fcamp");
	}

	Channel = getval("autochan");
}

void
setdxtx(void)
{
	if ( strcmp(Synthname,"DX-100")==0 )
		Tx81 = 0;
	else
		Tx81 = 1;
}

void
setopval(int n,char *str,int v)
{
	char buff[32];
	sprintf(buff,"op%d%s",n,str);
	setval(buff,v);
}

int
getopval(int n,char *str)
{
	char buff[32];
	sprintf(buff,"op%d%s",n,str);
	return(getval(buff));
}

/*
 * The routines below are used (in the P array) for printing the
 * values of various parameters (e.g. the vism3num routine prints
 * the value-3, which is appropriate for the 'detune' parameter.
 */

char Numbuff[8];

char *visnum();

char *
vism3num(v)
{
	sprintf(Numbuff,"%d",v-3);
	return(Numbuff);
}

char *visonoff();

char *
vismono(v)
{
	if ( v==0 )
		return("poly");
	else
		return("mono");
}

/*
            4    2  4    2         4                             4
            |    |  |    |         |               4             |
        2---3    ---3    3  4   2  3   1  4     ___|___    1  2  3
        |           |    |  |   |  |   |  |     |  |  |    |__|__|
        1           1    1---   1---   2  3     1  2  3
                                       |__|     |__|__|
                                                             1  2  3  4
                                                             |__|__|__|
 */

char *Algostr[] = {
	"1     ~d2---3~u~l|~u~l4~d~d~d~l~l~l~l~l|~l~d1",
	"2     ~d---3~l~l~l~l~u|  |~l~l~l~l~u2  4~l~d~d~d|~l~d1",
	"3     ~d3  4~l~l~l~l~u|~l~u2~l~d~d~d|  |~d~l~l~l~l1---",
	"4     ~d2  3~l~u|~u~l4~l~d~d~d~l~l~l|  |~l~l~l~l~d1---",
	"5     ~d~u1  4~d~l~l~l~l|  |~d~l~l~l~l2  3~d~l~l~l~l----",
	"6     ~d|  |  |~u~l~l~l~l~l~l~l___|___~u~l~l~l~l4~l~d~d~d~l~l~l1  2  3~d~l~l~l~l~l~l~l|__|__|",
	"7     ~d1  2  3~u~l|~u~l4~l~d~d~d~l~l~l~l~l~l|__|__|",
	"8     ~d1  2  3  4~d~l~l~l~l~l~l~l~l~l~l|__|__|__|"
};

char *
visdx1a(int v)
{
	if ( v >= 0 && v <= 7 )
		return(Algostr[v]);
	else
		return("????");
}

char *
viswave(int v)
{
	switch(v){
	case 0: return("saw up");
	case 1: return("square");
	case 2: return("triangle");
	case 3: return("s/hold");
	default: return("???");
	}
}

char *Freqstr[] = {	/* values from 0 to 63 */
	"0.50 ", "0.71 ", "0.78 ", "0.87 ", "1.00 ",
	"1.41 ", "1.57 ", "1.73 ", "2.00 ", "2.82 ",
	"3.00 ", "3.14 ", "3.46 ", "4.00 ", "4.24 ",
	"4.71 ", "5.00 ", "5.19 ", "5.65 ", "6.00 ",
	"6.28 ", "6.92 ", "7.00 ", "7.07 ", "7.85 ",
	"8.00 ", "8.48 ", "8.65 ", "9.00 ", "9.42 ",
	"9.89 ", "10.00", "10.38", "10.99", "11.00",
	"11.30", "12.00", "12.11", "12.56", "12.72",
	"13.00", "13.84", "14.00", "14.10", "14.13",
	"15.00", "15.55", "15.57", "15.70", "16.96",
	"17.27", "17.30", "18.37", "18.84", "19.03",
	"19.78", "20.41", "20.76", "21.20", "21.98",
	"22.49", "23.55", "24.22", "25.95"
};

char *
visfreq(int v)
{
	if ( v >=0 && v <= 63 )
		return ( Freqstr[v] );
	else
		return("????");
}

void
sendvced(char *data)
{
	char vdata[DX100VSIZE];
	int n, cksum, c;

	clrdata(vdata,DX100VSIZE);
	vmtovced(data,vdata);
	sendmidi(0xf0);
	sendmidi(0x43);
	sendmidi(Channel-1);	/* channel # */
	sendmidi(0x03);		/* format type */
	sendmidi(0x00);		/* byte count */
	sendmidi(0x5d);		/* byte count */
	cksum = 0;
	for ( n=0; n<93; n++ ) {
		sendmidi(c = (int)(vdata[n]));
		cksum += c;
	}
	sendmidi((-cksum) & 0x7f);
	sendmidi(EOX);
}

/*
 * dx1sedit
 *
 * Send a single voice to the edit buffer of the DX.
 */

void
dx1sedit(char *data)
{
	setdxtx();
	if ( Tx81 )
		sendaced(data);
	sendvced(data);
}

void
sendaced(char *data)
{
	char *p, vdata[DX100VSIZE];
	int n, cksum, c;

	clrdata(vdata,DX100VSIZE);
	vmtoaced(data,vdata);
	sendmidi(0xf0);
	sendmidi(0x43);
	sendmidi(Channel-1);	/* channel # */
	sendmidi(0x7e);		/* format type */
	sendmidi(0x00);		/* byte count */
	sendmidi(0x21);		/* byte count */
	p = "LM  8976AE";
	cksum = 0;
	while ( (c=(int)(*p++)) != '\0' ) {
		sendmidi(c);
		cksum += c;
	}
	for ( n=0; n<23; n++ ) {
		sendmidi(c=(int)(vdata[n]));
		cksum += c;
	}
	sendmidi((-cksum) & 0x7f);
	sendmidi(EOX);
}

/*
 * vmtovced
 *
 * convert a vmem format voice to vced format.
 */

void
vmtovced(char *data,char *vdata)
{
	int vop, dop, n;

	for ( n=0; n<4; n++ ) {
		/* vop = Dopmap[n]*13; */
		vop = Dopmap[n]*13;
		dop = Dopmap[n]*10;
		vdata[vop+0] = data[dop+0];	/* attack rate */
		vdata[vop+1] = data[dop+1];	/* decay 1 rate */
		vdata[vop+2] = data[dop+2];	/* decay 2 rate */
		vdata[vop+3] = data[dop+3];	/* release rate */
		vdata[vop+4] = data[dop+4];	/* decal 1 level */
		vdata[vop+5] = data[dop+5];	/* keyboard scaling level */
		vdata[vop+6] = (data[dop+9]>>3);/* keyboard scaling rate */
		vdata[vop+7] = (data[dop+6]>>3)&7;	/* eg bias sens. */
		vdata[vop+8] = (data[dop+6]>>6)&1;	/* amp. mod. enable */
		vdata[vop+9] = (data[dop+6]&7);	/* key velocity */
		vdata[vop+10] = data[dop+7];	/* output level */
		vdata[vop+11] = data[dop+8];	/* osc. frequency */
		vdata[vop+12] = (data[dop+9]&7);	/* detune */
	}
	vdata[52] = (data[40]&7);	/* algorithm */
	vdata[53] = (data[40]>>3)&7;	/* feedback level */
	vdata[54] = data[41];		/* lfo speed */
	vdata[55] = data[42];		/* lfo delay */
	vdata[56] = data[43];		/* pitch modulation depth */
	vdata[57] = data[44];		/* amplitude modulation depth */
	vdata[58] = (data[40]>>6)&1;	/* lfo sync */
	vdata[59] = data[45]&3;		/* lfo wave */
	vdata[60] = (data[45]>>4)&7;		/* pitch modulation sens. */
	vdata[61] = (data[45]>>2)&3;		/* amp. modulation sens. */
	vdata[62] = data[46];		/* transpose */
	vdata[63] = (data[48]>>3)&1;	/* play mode (poly/mono) */
	vdata[64] = data[47];		/* pitch bend range */
	vdata[65] = (data[48]&1);	/* portamento mode */
	vdata[66] = data[49];		/* portamento time */
	vdata[67] = data[50];		/* foot volume range */
	vdata[68] = (data[48]>>2)&1;	/* sustain foot switch */
	vdata[69] = (data[48]>>1)&1;	/* portamento foot switch */
	vdata[70] = (data[48]>>4)&1;	/* chorus switch */
	vdata[71] = data[51];		/* mod. wheel pitch mod. range */
	vdata[72] = data[52];		/* mod. wheel ampli. mod. range */
	vdata[73] = data[53];		/* breath pitch mod. range */
	vdata[74] = data[54];		/* breath ampli. mod. range */
	vdata[75] = data[55];		/* breath control pitch bias range */
	vdata[76] = data[56];		/* breath control EG bias range */
	for ( n=77; n<93; n++ )		/* voice name AND pitch EG rates */
		vdata[n] = data[n-20];
}

/*
 * vmtoaced
 *
 * Convert a vmem format voice to aced format (TX81Z).
 */

void
vmtoaced(char *data,char *adata)
{
	int vop, aop, n;

	for ( n=0; n<4; n++ ) {
	    vop = 73 + Dopmap[n]*2;
	    aop = Dopmap[n]*5;
	    adata[0+aop] = (data[vop]>>3) & 01;    /* fixed freq (0,1) */
	    adata[1+aop] = data[vop] & 07;	   /* fixed freq range (0-7) */
	    adata[2+aop] = data[vop+1] & 017;	   /* freq range fine (0-15) */
	    adata[3+aop] = (data[vop+1]>>4) & 07;  /* op. waveform (0-7) */
	    adata[4+aop] = (data[vop]>>3) & 03;   /* EG shift (0-3) */
	}
	adata[20] = data[81] & 07;	/* reverb rate */
	adata[21] = data[82];	/* Foot controller pitch */
	adata[22] = data[83];	/* Foot controller amp. */
}

#ifdef OLD
/*
 * Send a single parameter value.
 */
void
sendparam(int param,int val)
{
	sendmidi(0xf0);
	sendmidi(0x43);
	sendmidi(0x10);	/* Channel? */
	sendmidi(0x12);
	sendmidi(param);
	sendmidi(val);
	sendmidi(EOX);
}

/*
 * remotely press a key on the DX
 */
void
presskey(int key,int val)
{
	sendmidi(0xf0);
	sendmidi(0x43);
	sendmidi(0x10);	/* Channel? */
	sendmidi(0x08);
	sendmidi(key);
	sendmidi(val);
	sendmidi(EOX);
}

/*
 * tovmem
 *
 * convert a vced format voice to vmem format.
 *
 * vdata is in vced format data
 * data is in vmem format
 */

void
tovmem(char *vdata,char *data)
{
	int vop, dop, n;

	for ( n=0; n<4; n++ ) {
		vop = Dopmap[n]*13;
		dop = Dopmap[n]*10;
		data[dop+0] = vdata[vop+0];	/* attack rate */
		data[dop+1] = vdata[vop+1];	/* decay 1 rate */
		data[dop+2] = vdata[vop+2];	/* decay 2 rate */
		data[dop+3] = vdata[vop+3];	/* release rate */
		data[dop+4] = vdata[vop+4];	/* decal 1 level */
		data[dop+5] = vdata[vop+5];	/* keyboard scaling level */
				/* amp. mod. enab/eg bias sens/key velocity */
		data[dop+6]=(vdata[vop+8]<<6) | (vdata[vop+7]<<3) | vdata[vop+9];
		data[dop+7] = vdata[vop+10];	/* output level */
		data[dop+8] = vdata[vop+11];	/* osc. frequency */
				/* key scaling rate/detune */
		data[dop+9] = (vdata[vop+6]<<3) | vdata[vop+12];
	}
		/* lfo sync/feedback level/algorithm */
	data[40] = (vdata[58]<<6) | (vdata[53]<<3) | vdata[52];
	data[41] = vdata[54];		/* lfo speed */
	data[42] = vdata[55];		/* lfo delay */
	data[43] = vdata[56];		/* pitch modulation depth */
	data[44] = vdata[57];		/* amplitude modulation depth */
		/* pitch mod. sens/amp. mod. sens/lfo wave */
	data[45] = (vdata[60]<<4) | (vdata[61]<<2) | vdata[59];
	data[46] = vdata[62];		/* transpose */

		/* chorus/playmode/sustain/portamento-foot/portamento-mode */
	data[48] = (vdata[70]<<4)|(vdata[63]<<3)|(vdata[68]<<2)|(vdata[69]<<1)
		| vdata[65];

	data[47] = vdata[64];		/* pitch bend range */
	data[49] = vdata[66];		/* portamento time */
	data[50] = vdata[67];		/* foot volume range */
	data[51] = vdata[71];		/* mod. wheel pitch mod. range */
	data[52] = vdata[72];		/* mod. wheel ampli. mod. range */
	data[53] = vdata[73];		/* breath pitch mod. range */
	data[54] = vdata[74];		/* breath ampli. mod. range */
	data[55] = vdata[75];		/* breath control pitch bias range */
	data[56] = vdata[76];		/* breath control EG bias range */
	for ( n=77; n<93; n++ )		/* voice name AND pitch EG rates */
		data[n-20] = vdata[n];
}
#endif

/* dx1nof - return a pointer to the voice name buried in data */
char *
dx1nof(char *data)
{
	static char currbuff[DX100NSIZE+1];
	char *p;
	int m;

	p = currbuff;
	for ( m=0; m<10; m++ )
		*p++ = data[57+m];
	*p = '\0';
	return(currbuff);
}

/* dx1snof - set the voice name buried in data to name */
void
dx1snof(char *data,char *name)
{
	char *p;
	int m;

	for ( p=name,m=0; *p!='\0' && m<10; p++,m++ )
		data[57+m] = *p;
	for ( ; m<10; m++ )
		data[57+m] = ' ';
}

/* dx1sbulk - send a bulk dump to the DX-100 */
int
dx1sbulk(char *data)
{
	int c, v, n, cksum;

	sendmidi(0xf0);
	sendmidi(0x43);
	sendmidi(Channel-1);	/* Channel # */
	sendmidi(0x04);
	sendmidi(0x20);
	sendmidi(0x00);
	cksum = 0;
	/* send 32 voices worth of data */
	for ( v=0; v<32; v++ ) {
		for ( n=0; n<DX100VSIZE; n++ ) {
			/* The DX100 can only handle 24 voices (but needs */
			/* to have 32 voices worth of data sent, anyway) */
			if ( v >= 24 && ( ! Tx81 ) )
				c = 0;
			else
				c = VOICEBYTE(data,v,n);
			sendmidi(c & 0xff);
			cksum += c;
		}
	}
	sendmidi((-cksum) & 0x7f);
	sendmidi(0xf7);
	return(0);
}

/* dx1gbulk - Request and read a bulk dump from the DX-100 */
int
dx1gbulk(char *data)
{
	int c, n, v, b1, b2, cksum, ret = 1;
	long begin, toolong;
	static char reason[128];
	int nread = 0;

	setdxtx();
	flushmidi();

	sendmidi(0xf0);
	sendmidi(0x43);
	sendmidi(0x20 | (Channel-1) );	/* Channel # */
	sendmidi(4);			/* 4 == 32 voice bulk dump */
	sendmidi(EOX);			/* EOX */

	begin = milliclock();
	toolong = begin + 1000 * TIMEOUT;

	if (synthinfileflag) {
windmsg("Hey, synthinfileflag!?");
		getmidi(); /* the 0xf0 byte */
	}

	/* wait for the x43 byte starting the dump */
	while ( milliclock() < toolong ) {
		if ( ! STATMIDI )
			continue;
		c = (getmidi() & 0xff);
		nread++;
		if ( c == 0x43 )
			break;
	}
	if ( c != 0x43 ) {
		sprintf(reason,"Timeout waiting for 0x43 (read %d bytes, c=0x%02x)",nread,c);
		Reason = reason;
		/* Reason = "Timeout waiting for 0x43"; */
		goto getout;
	}
	getmidi();	/* channel # */
	getmidi();	/* format # */
	getmidi();	/* byte count high byte */
	getmidi();	/* byte count low byte */

	cksum = 0;
	/* 32 voices are dumped */
	for ( v=0; v<32; v++ ) {
		for ( n=0; n<DX100VSIZE; n++ ) {
			/* twiddle your thumbs, but not forever */
			while ( ! STATMIDI ) {
				if ( milliclock() > toolong )
					goto timeout;	/* the end of an era */
			}
			c = (getmidi() & 0xff);
			/* Ignore non-data bytes ? */
			if ( c & 0x80 )
				continue;
			/* compute checksum */
			cksum += c;
			/* Only 24 voices are used on the DX100 */
			if ( v < 24 || Tx81 )
				VOICEBYTE(data,v,n) = c;
		}
	}
timeout:
	if ( v < 32 ) {
		Reason = "Timeout while reading!";
		goto getout;
	}
	b1 = (getmidi() & 0xff);	/* Checksum */
	b2 = (getmidi() & 0xff);	/* EOX */
	cksum = (-cksum) & 0x7f;	/* convert to what we must match */
/* printf("(cksum=%d)",cksum); */
	if ( b2 != EOX )
		Reason = "EOX not received";
	else if ( b1 != cksum ) {
		static char ckbuff[80];
		sprintf(ckbuff,"Checksum doesn't match (got %d expected %d)",b1,cksum);
		Reason = ckbuff;
		ret = 0;
	}
	else {
		Reason = "";
		ret = 0;	/* all's well */
	}
getout:
	return(ret);
}

#ifdef OLDSTUFF
int
dxchecksum(char *data)
{
	int v, n, s=0;

	for ( v=0; v<DX100NVOICES; v++ ) {
		for ( n=0; n<DX100VSIZE; n++ ) {
			s += (int)(VOICEBYTE(data,v,n));
			while ( s > 128 )
				s -= 128;
		}
	}
	return(128-s);
}
#endif

int
freqin(int crs,int fin)
{
	int n, f;

	txinit();
	f = txfreq[crs*16+fin];
	for ( n=0; n<txleng; n++ ) {
		if ( txfreq[txindex[n]] == f )
			return(n);
	}
	return(0);
}

void
freqout(int v,int *acrs,int *afin)
{
	int i;

	i = txindex[v];
	*acrs = i/16;
	*afin = i%16;
}

void
txinit(void)
{
	int n, k;
	char *parm;

	if ( txindex != NULL )
		return;
	/* create an array of indexes into txfreq, giving a sorted */
	/* list of unique frequencies. */
	txindex = (int *) alloc(sizeof(int) * 64 * 16);
	for ( n=0; n<64; n++ ) {
		for ( k=0; k<16; k++ ) {
			int freq = txfreq[n*16+k];
			register int i, f;
			register int *p, *endp;

			/* insertion sort, starting from top of already */
			/* sorted list, since the values we're inserting */
			/* are almost sorted already. */
			for ( i=txleng-1; i>=0; i-- ) {
				if ( (f=txfreq[txindex[i]]) < freq )
					break;
				if ( f == freq )
					goto dontadd;
			}
			i++;
			/* shift everything up one */
			p = &txindex[txleng];
			endp = &txindex[i];
			for ( ; p>endp; p-- )
				*p = *(p-1);
			txindex[i] = 16*n+k;
			txleng++;
		    dontadd: ;
		}
	}
	/* set the maximum value for the frequency parameters */
	parm = "op#freq";
	for ( n=1; n<=4; n++ ) {
		parm[2] = '0' + n;
		if ( (k=parmindex(parm)) >= 0 )
			P[k].p_max = txleng-1;
	}
}
